/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.smoothboot.mixin;

import com.abdelaziz.smoothboot.SmoothBoot;
import com.abdelaziz.smoothboot.util.LoggingForkJoinWorkerThread;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.Util;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Util.class})
public abstract class UtilMixin {
    @Shadow
    @Final
    @Mutable
    private static ExecutorService f_137443_;
    @Shadow
    @Final
    @Mutable
    private static ExecutorService f_137444_;
    @Shadow
    @Final
    @Mutable
    private static ExecutorService f_137445_;
    @Shadow
    @Final
    private static AtomicInteger f_137442_;

    @Shadow
    private static void m_137495_(Thread thread, Throwable throwable) {
    }

    @Inject(method={"getBootstrapExecutor"}, at={@At(value="HEAD")})
    private static void onGetBootstrapExecutor(CallbackInfoReturnable<Executor> ci) {
        if (!SmoothBoot.initBootstrap) {
            f_137443_ = UtilMixin.replWorker("Bootstrap");
            SmoothBoot.LOGGER.debug("Bootstrap worker replaced");
            SmoothBoot.initBootstrap = true;
        }
    }

    @Inject(method={"getMainWorkerExecutor"}, at={@At(value="HEAD")})
    private static void onGetMainWorkerExecutor(CallbackInfoReturnable<Executor> ci) {
        if (!SmoothBoot.initMainWorker) {
            f_137444_ = UtilMixin.replWorker("Main");
            SmoothBoot.LOGGER.debug("Main worker replaced");
            SmoothBoot.initMainWorker = true;
        }
    }

    @Inject(method={"getIoWorkerExecutor"}, at={@At(value="HEAD")})
    private static void onGetIoWorkerExecutor(CallbackInfoReturnable<Executor> ci) {
        if (!SmoothBoot.initIOWorker) {
            f_137445_ = UtilMixin.replIoWorker();
            SmoothBoot.LOGGER.debug("IO worker replaced");
            SmoothBoot.initIOWorker = true;
        }
    }

    private static ExecutorService replWorker(String name) {
        if (!SmoothBoot.initConfig) {
            SmoothBoot.regConfig();
            SmoothBoot.initConfig = true;
        }
        return new ForkJoinPool(Mth.m_14045_((int)UtilMixin.select(name, SmoothBoot.config.threadCount.bootstrap, SmoothBoot.config.threadCount.main), (int)1, (int)Short.MAX_VALUE), forkJoinPool -> {
            String workerName = "Worker-" + name + "-" + f_137442_.getAndIncrement();
            SmoothBoot.LOGGER.debug("Initialized " + workerName);
            LoggingForkJoinWorkerThread forkJoinWorkerThread = new LoggingForkJoinWorkerThread(forkJoinPool, SmoothBoot.LOGGER);
            forkJoinWorkerThread.setPriority(UtilMixin.select(name, SmoothBoot.config.threadPriority.bootstrap, SmoothBoot.config.threadPriority.main));
            forkJoinWorkerThread.setName(workerName);
            return forkJoinWorkerThread;
        }, UtilMixin::m_137495_, true);
    }

    private static ExecutorService replIoWorker() {
        return Executors.newCachedThreadPool(runnable -> {
            String workerName = "IO-Worker-" + f_137442_.getAndIncrement();
            SmoothBoot.LOGGER.debug("Initialized " + workerName);
            Thread thread = new Thread(runnable);
            thread.setName(workerName);
            thread.setDaemon(true);
            thread.setPriority(SmoothBoot.config.threadPriority.io);
            thread.setUncaughtExceptionHandler(UtilMixin::m_137495_);
            return thread;
        });
    }

    private static <T> T select(String name, T bootstrap, T main) {
        return Objects.equals(name, "Bootstrap") ? bootstrap : main;
    }
}

